/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.visuals;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.game.EntityDeathEvent;
import Krasnodar.rockstarnew.systems.event.impl.render.Render3DEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.setting.settings.ColorSetting;
import Krasnodar.rockstarnew.utility.animation.base.Animation;
import Krasnodar.rockstarnew.utility.animation.base.Easing;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.colors.Colors;
import Krasnodar.rockstarnew.utility.math.MathUtility;
import Krasnodar.rockstarnew.utility.render.DrawUtility;
import Krasnodar.rockstarnew.utility.render.RenderUtility;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_9801;

@ModuleInfo(name="Kill Effects", category=ModuleCategory.VISUALS, desc="modules.descriptions.kill_effects")
public class KillEffects
extends BaseModule {
    private final List<Lightning> lightnings = new ArrayList<Lightning>();
    private final ColorSetting color = new ColorSetting(this, "modules.settings.kill_effects.color").color(Colors.ACCENT);
    private final EventListener<EntityDeathEvent> onEntityDeath = event -> {
        if (!event.getEntity().method_31481()) {
            this.lightnings.add(new Lightning(event.getEntity().method_19538(), this.color.getColor()));
        }
    };
    private final EventListener<Render3DEvent> on3DRender = event -> {
        class_4587 ms = event.getMatrices();
        class_4184 camera = KillEffects.mc.field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        ms.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        class_2960 id = Rockstar.id("textures/bloom.png");
        RenderSystem.setShaderTexture((int)0, (class_2960)id);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        for (Lightning lightning : this.lightnings) {
            lightning.render(builder, event.getMatrices(), camera);
            if (lightning.animation.getValue() != 1.0f) continue;
            lightning.showing = false;
        }
        class_9801 builtBuffer = builder.method_60794();
        if (builtBuffer != null) {
            class_286.method_43433((class_9801)builtBuffer);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.setShaderTexture((int)0, (int)0);
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        RenderSystem.disableDepthTest();
        ms.method_22909();
        this.lightnings.removeIf(lightningx -> !lightningx.showing && lightningx.animation.getValue() == 0.0f);
    };

    static class Lightning {
        final class_243 pos;
        final ColorRGBA color;
        boolean showing = true;
        final Animation animation = new Animation(300L, 0.0f, Easing.FIGMA_EASE_IN_OUT);
        final List<class_243> poses = new ArrayList<class_243>();

        public Lightning(class_243 pos, ColorRGBA color) {
            this.pos = pos;
            this.color = color;
            class_243 lastPos = pos;
            for (int i = 0; i < 200; ++i) {
                lastPos = lastPos.method_1031((double)MathUtility.random(-0.4f, 0.4f), 0.25, (double)MathUtility.random(-0.4f, 0.4f));
                this.poses.add(lastPos);
            }
        }

        void render(class_287 builder, class_4587 ms, class_4184 camera) {
            this.animation.setEasing(Easing.BOUNCE_IN);
            this.animation.setDuration(500L);
            this.animation.update(this.showing);
            for (class_243 pos : this.poses) {
                float size = (float)(2.0 + 5.0 * (pos.field_1351 - this.pos.field_1351) / 50.0);
                ms.method_22903();
                RenderUtility.prepareMatrices(ms, pos);
                ms.method_22907(camera.method_23767());
                DrawUtility.drawImage(ms, builder, (double)(-size / 2.0f), (double)(-size / 2.0f), 0.0, (double)size, (double)size, this.color.withAlpha(255.0f * this.animation.getValue() * 0.4f));
                ms.method_22909();
            }
        }
    }
}

